clearvars;
close all;

dtvalues = [1,3,10,30,100];
cm = [1,2]; %Cloning Methods
colours = {'rx-','bx-'};

for n=1:size(cm,2)


for m = 1:size(dtvalues,2)
seed = 0;

logt = 4;
L = 50;
lognc = 5;
sLL = 20;
dt = dtvalues(m);

repspf=10; %Repeats per file
nfiles=10;

for j = seed:seed+nfiles-1
FILENAME = sprintf('%dKTrack%d,%d,%d,%d,%d,%d.txt',j*10,cm(n),logt,L,lognc,sLL,dt);
fileID = fopen(FILENAME,'r');
formatSpec = '%f';

A = fscanf(fileID,formatSpec);

for i=1:repspf
    k(j*repspf-seed*repspf+i) = A(i*5 - 4);
end
end

kave(m) = mean(k)/L
ksterr(n,m) = std(k/L)/sqrt(repspf*nfiles)
end

hold on, plot(dtvalues,ksterr(n,:),colours{n},'MarkerSize',12,'LineWidth', 4);
set(gca,'xscale','log')
xlim([10^(0),10^(2)]);
ylim([0,1.2*max(max(ksterr))]);
xlabel('Cloning Interval');
ylabel('Standard Error');

set(gcf,'units','points','position',[10,10,400,300]);
set(gca, 'FontSize', 30);
set(gca, 'LineWidth', 4);

plotname = sprintf('ErrorTau.png');
saveas(gcf,plotname);
end